#ifndef __PROFIBUS_APM_DIAG_H
#define __PROFIBUS_APM_DIAG_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS Master APM Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//    #define TASK_F_NO_BUS_DP          54  /* no bus parameters */
//    #define TASK_F_INVALID_BUS_DP     55  /* bus parameters faulty */
//    #define TASK_F_NO_SL_TAB          56  /* no slave data sets */
//       
//    #define TASK_F_INVALID_SL_TAB     57  /* slave data set faulty */
//        
//    #define TASK_F_DPM_UNKNOWN_MODE   63  /* warm start with unknown mode */
//    #define TASK_F_RAM_OVERRUN        64  /* extended ram exeeded */
//    
//    #define TASK_F_SL_PRM_FAULT       65  /* slave data set faulty */
//
//
//
//    #define CON_NA     0x11   /* no reaction of the remote station         */
//    #define CON_DS     0x12   /* cocal-FDL/PHY not in logical token ring   */
//    #define CON_RS     0x03   /* master request not supported by the slave */
//    #define CON_NR     0x09   /* no response data                          */
//    #define CON_DS     0x12   /* local FDL not in logical token ring       */
/////////////////////////////////////////////////////////////////////////////////////
// Error codes 0x0000 .. 0x00FF  reserved error codes
//   the low byte of this error code corresponds to error codes of the
//   PROFIBUS stack V1  
//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_NO_FSPMM
//
// MessageText:
//
//  No FSPMM-Task or -queue found to communicate.
//
#define TLR_DIAG_E_PROFIBUS_APM_NO_FSPMM ((TLR_RESULT)0xC0390032L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_ADR_DOUBLE
//
// MessageText:
//
//  Double station address detected.
//
#define TLR_DIAG_E_PROFIBUS_ADR_DOUBLE   ((TLR_RESULT)0xC039003AL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_MAX_OUTPUT_OFFSET
//
// MessageText:
//
//  Maximum output offset reached.
//
#define TLR_DIAG_E_PROFIBUS_MAX_OUTPUT_OFFSET ((TLR_RESULT)0xC039003BL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_MAX_INPUT_OFFSET
//
// MessageText:
//
//  Maximum input offset reached.
//
#define TLR_DIAG_E_PROFIBUS_MAX_INPUT_OFFSET ((TLR_RESULT)0xC039003CL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_OUTPUT_OVERLAP
//
// MessageText:
//
//  Overlap in output data.
//
#define TLR_DIAG_E_PROFIBUS_OUTPUT_OVERLAP ((TLR_RESULT)0xC039003DL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_INPUT_OVERLAP
//
// MessageText:
//
//  Overlap in input data.
//
#define TLR_DIAG_E_PROFIBUS_INPUT_OVERLAP ((TLR_RESULT)0xC039003EL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_WATCHDOG_ERROR
//
// MessageText:
//
//  Watchdog Error.
//
#define TLR_DIAG_E_PROFIBUS_APM_WATCHDOG_ERROR ((TLR_RESULT)0xC03900DCL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_AUTOCLEAR_ERROR
//
// MessageText:
//
//  Autoclear activtead.
//
#define TLR_DIAG_E_PROFIBUS_APM_AUTOCLEAR_ERROR ((TLR_RESULT)0xC03900DEL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_OUT_OF_PACKET
//
// MessageText:
//
//  No packet left to communicate.
//
#define TLR_DIAG_E_PROFIBUS_APM_OUT_OF_PACKET ((TLR_RESULT)0xC03900E1L)

/////////////////////////////////////////////////////////////////////////////////////
// Error codes 0x0100 .. free error codes 
//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_NO_INIT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to initialize the Master state machine failed.
//
#define TLR_DIAG_E_PROFIBUS_APM_NO_INIT_PACKET ((TLR_RESULT)0xC0390100L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_NO_SET_MODE_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to set the Master mode failed.
//
#define TLR_DIAG_E_PROFIBUS_APM_NO_SET_MODE_PACKET ((TLR_RESULT)0xC0390101L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_NO_SET_OUTPUT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to set output date fail.
//
#define TLR_DIAG_E_PROFIBUS_APM_NO_SET_OUTPUT_PACKET ((TLR_RESULT)0xC0390102L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_NO_GET_INPUT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to request input data failed.
//
#define TLR_DIAG_E_PROFIBUS_APM_NO_GET_INPUT_PACKET ((TLR_RESULT)0xC0390103L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_GET_INPUT_FAIL
//
// MessageText:
//
//  Getting input data fail.
//
#define TLR_DIAG_E_PROFIBUS_APM_GET_INPUT_FAIL ((TLR_RESULT)0xC0390104L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APM_SET_OUTPUT_FAIL
//
// MessageText:
//
//  Write Slave output data failed.
//
#define TLR_DIAG_E_PROFIBUS_APM_SET_OUTPUT_FAIL ((TLR_RESULT)0xC0390105L)




#endif  //__PROFIBUS_APM_DIAG_H

